#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
#include <climits>

using namespace std;

struct tacka {
    long long x, y;

    bool operator<(const tacka &druga) const {
        return x < druga.x || (x == druga.x && y < druga.y);
    }
};

long long cross(const tacka &O, const tacka &A, const tacka &B) {
    return (A.x - O.x) * (B.y - O.y) - (A.y - O.y) * (B.x - O.x);
}

long long povrsinaP(const vector<tacka> &poligon) {
    long long povrsina = 0;
    int n = poligon.size();
    for (int i = 0; i < n; i++) {
        int j = (i + 1) % n;
        povrsina += poligon[i].x * poligon[j].y - poligon[j].x * poligon[i].y;
    }
    return abs(povrsina);
}

vector<tacka> kOmotac(vector<tacka> tacke) {
    sort(tacke.begin(), tacke.end());
    vector<tacka> omotac;
    for (const tacka &p : tacke) {
        while (omotac.size() >= 2 && cross(omotac[omotac.size() - 2], omotac[omotac.size() - 1], p) <= 0) {
            omotac.pop_back();
        }
        omotac.push_back(p);
    }
    int donji = omotac.size();
    for (int i = tacke.size() - 2; i >= 0; i--) {
        while (omotac.size() > donji && cross(omotac[omotac.size() - 2], omotac[omotac.size() - 1], tacke[i]) <= 0) {
            omotac.pop_back();
        }
        omotac.push_back(tacke[i]);
    }

    omotac.pop_back();
    return omotac;
}

int main() {
    int n;
    cin >> n;

    vector<tacka> tacke(n);
    for (int i = 0; i < n; i++) {
        cin >> tacke[i].x >> tacke[i].y;
    }
    long long najmanja = LLONG_MAX;
    for (int i = 0; i < n; i++) {
        vector<tacka> preostale;
        for (int j = 0; j < n; j++) {
            if (i != j) {
                preostale.push_back(tacke[j]);
            }
        }
        vector<tacka> omotac = kOmotac(preostale);
        najmanja = min(najmanja, povrsinaP(omotac));
    }
    cout << najmanja / 2 << endl;
    return 0;
}